
function HFP_session(subName,curr_cond)

% HFP Code for Elliott Lab
% Written by SLE 3/24/17
% Modified by CPF 

a = cd; % folder where the program is.


hfpDate = date;
saveFile = sprintf('%sHFP',subName);
numRep = 3; %number of repetitions

Calib_Dire = cd('/Users/clemente/Dropbox/Luminotecnia/2017/Chicago Lab files/2 Experiments/Color AfterImage_Exp_Room_150/2nd/1 Programs/001 After Image GUI Project');
%load in monitor calibration information & color set parameters
load colorCalFile1.mat
fprintf('\nLast calibration was %s\n', describe.date);
pixDec = pix/length(pix); %converts 1001 numbers to decimals
lum = 5; %in cd/m^2

rgbMat(:,4) = pix;
rgbMat(:,1) = redProp(:)*maxPhosXYZ(1,2);
rgbMat(:,2) = grnProp(:)*maxPhosXYZ(2,2);
rgbMat(:,3) = blueProp(:)*maxPhosXYZ(3,2);

for i=1:3
    settings(i) = pix(dsearchn(rgbMat(:,i), lum));
end
%gives an index into the phosphor table to find a value btw 0-1
%correponding to that luminance
initial_RED = settings(1)
initial_GREEN = settings(2)
initial_BLUE = settings(3)
%stepSize is based on the total number of unique luminance values in the rgbMat so we don't get stuck pushing the button to move the luminance of 1 phosphor
stepSize = 2;

%% Load previous HFP values
aa = cd('/Users/clemente/Dropbox/Luminotecnia/2017/Chicago Lab files/2 Experiments/Color AfterImage_Exp_Room_150/2nd/1 Programs/A Outputs');
name = sprintf('%sHFP.mat', subName);
if exist(name, 'file') == 2

load(name)

% bg = [];
% rg = [];
% br = [];
% br_check = [];

else 

Prev_bg = []; bg = [];
Prev_rg = []; rg = [];
Prev_br = []; br = [];
Prev_brcheck = []; br_check = [];

end

%% Set up toolbox variables
% switch color range to normalized 0 - 1 range:
% PsychDefaultSetup(2);
expScreen = 1;
[window, windowRect] = PsychImaging('OpenWindow', expScreen, [0 0 0], [], [], []);
% Screen('OpenWindow',0, [0 0 0]); %makes main screen dark
%PsychImaging('OpenWindow', expScreen, wRGB);
[xcent,ycent] = RectCenter(windowRect);
center = [xcent ycent];

%% TIMING
%find frames per second
ifi = Screen('GetFlipInterval', window);% Measure the vertical refresh rate of the monitor
topPriorityLevel = MaxPriority(window);% Retreive the maximum priority number
framesPerSec = round(1/ifi);
hfpFreq = 15;
waitframes = floor(framesPerSec/hfpFreq); %number of frames to wait between refresh
%freqRefresh = ifi*framesPerSec/hfpFreq;

%% Stimulus Size Parameters
circleDeg = 1.5;
pixPerDeg =60;
circlePix = circleDeg*pixPerDeg;
tstcircle = [xcent - circlePix/2 ycent - circlePix/2 xcent + circlePix/2 ycent + circlePix/2];

cd(a); % return to folder where the program is
%run experiment
Priority(topPriorityLevel);
% for iRepeat = 1:numRep
    stim_order = [1 1 1 2 2 2 3 3 3];%randperm(3);
    keypress = 0;
    %Speak('Setting %i', iRepeat)
    commandwindow;
    for j = 1:9
        vbl = Screen('Flip', window);
        
        switch stim_order(j)
            case 1 %RG
                current_RED = initial_RED;
                colClut_one = [pixDec(current_RED) 0 0];
                colClut_two = [0 pixDec(initial_GREEN) 0];
            case 2 %BG
                current_BLUE = initial_BLUE;
                colClut_one = [0 0 pixDec(current_BLUE)];
                colClut_two = [0 pixDec(initial_GREEN) 0];
            case 3 %RB
                current_RED = initial_RED;
                colClut_one = [0 0 pixDec(initial_BLUE)];
                colClut_two = [pixDec(current_RED) 0 0];
        end
        
        %ListenChar(2);
        BeginMatch = 0;
%         Speak('press start to begin')
        while ~BeginMatch %wait for initial key press
            if(CharAvail)   % check for keypress, record if key=4
                [char] = GetChar;
                if char =='8'
                    BeginMatch = 1;
                end
                FlushEvents('keyDown');
            end
        end
        
        FlushEvents('keyDown');
        %Speak('Next Session')
        DoneMatch = 0;
        count = 0; %count the number of frames
        while ~DoneMatch %look for key presses and put up stimulus
            [ keyIsDown, timeSecs, keyCode ] = KbCheck;
            if(CharAvail)   % check for keypress, record if key=1 or 2 or 3
                [char] = GetChar;
                switch char
                    case '8'
                        DoneMatch = 1;
                        switch stim_order(j)
                            case 1 %RG
                                rg(j) = rgbMat(current_RED,1)/rgbMat(initial_GREEN,2)
                            case 2 %BG
                                bg(j-3) = rgbMat(current_BLUE,3)/rgbMat(initial_GREEN,2);
                            case 3 %BR
                                br(j-6) = rgbMat(initial_BLUE,3)/rgbMat(current_RED,1);
                        end
                    case '6'
                        switch stim_order(j)
                            case 1 %RG
                                if current_RED > 1001
                                    Speak('setting limit');
                                    current_RED = 1;
                                end
                                current_RED = current_RED + stepSize
                                colClut_one = [pixDec(current_RED) 0 0];
                                colClut_two = [0 pixDec(initial_GREEN) 0];
                            case 2 %BG
                                if current_BLUE > 1001
                                    Speak('setting limit');
                                    current_BLUE = 1;
                                end
                                current_BLUE = current_BLUE + stepSize;
                                colClut_one = [0 0 pixDec(current_BLUE)];
                                colClut_two = [0 pixDec(initial_GREEN) 0];
                            case 3 %BR
                                if current_RED > 1001
                                    Speak('setting limit');
                                    current_RED = 1;
                                end
                                current_RED = current_RED + stepSize;
                                colClut_one = [0 0 pixDec(initial_BLUE)];
                                colClut_two = [pixDec(current_RED) 0 0];
                        end
                        
                        case '9'
                        switch stim_order(j)
case 1 %RG
                                if current_RED > 1001
                                    Speak('setting limit');
                                    current_RED = 1;
                                end
                                current_RED = current_RED + stepSize/2;
                                colClut_one = [pixDec(current_RED) 0 0];
                                colClut_two = [0 pixDec(initial_GREEN) 0];
                            case 2 %BG
                                if current_BLUE > 1001
                                    Speak('setting limit');
                                    current_BLUE = 1;
                                end
                                current_BLUE = current_BLUE + stepSize/2;
                                colClut_one = [0 0 pixDec(current_BLUE)];
                                colClut_two = [0 pixDec(initial_GREEN) 0];
                            case 3 %BR
                                if current_RED > 1001
                                    Speak('setting limit');
                                    current_RED = 1;
                                end
                                current_RED = current_RED + stepSize/2;
                                colClut_one = [0 0 pixDec(initial_BLUE)];
                                colClut_two = [pixDec(current_RED) 0 0];
                        end
                    case '4'
                        switch stim_order(j)
                            case 1 %RG
                                if current_RED <= 0
                                    speak('setting limit');
                                    current_RED = 0;
                                else
                                    current_RED = current_RED - stepSize
                                end
                                colClut_one = [pixDec(current_RED) 0 0];
                                colClut_two = [0 pixDec(initial_GREEN) 0];
                            case 2 %BG
                                if current_BLUE <= 0
                                    speak('setting limit')
                                    current_BLUE = 0;
                                else
                                    current_BLUE = current_BLUE - stepSize;
                                end
                                colClut_one = [0 0 pixDec(current_BLUE)];
                                colClut_two = [0 pixDec(initial_GREEN) 0];
                            case 3 %BR
                                if current_RED <= 0
                                    speak('setting limit')
                                    current_RED = 0;
                                else
                                    current_RED = current_RED - stepSize;
                                end
                                colClut_one = [0 0 pixDec(initial_BLUE)];
                                colClut_two = [pixDec(current_RED) 0 0];
                        end
                        case '7'
                        switch stim_order(j)
                            case 1 %RG
                                if current_RED <= 0
                                    speak('setting limit');
                                    current_RED = 0;
                                else
                                    current_RED = current_RED - stepSize/2
                                end
                                colClut_one = [pixDec(current_RED) 0 0];
                                colClut_two = [0 pixDec(initial_GREEN) 0];
                            case 2 %BG
                                if current_BLUE <= 0
                                    speak('setting limit')
                                    current_BLUE = 0;
                                else
                                    current_BLUE = current_BLUE - stepSize/2;
                                end
                                colClut_one = [0 0 pixDec(current_BLUE)];
                                colClut_two = [0 pixDec(initial_GREEN) 0];
                            case 3 %BR
                                if current_RED <= 0
                                    speak('setting limit')
                                    current_RED = 0;
                                else
                                    current_RED = current_RED - stepSize/2;
                                end
                                colClut_one = [0 0 pixDec(initial_BLUE)];
                                colClut_two = [pixDec(current_RED) 0 0];
                        end
                end
                FlushEvents('keyDown');
            end
            Screen('FillOval', window, colClut_one, tstcircle);
            vbl = Screen('Flip', window, vbl + (waitframes - 0.5) * ifi);
            Screen('FillOval', window, colClut_two, tstcircle);
            vbl = Screen('Flip', window, vbl + (waitframes - 0.5) * ifi);
        end %while done
        Screen('FillOval', window, [0 0 0], windowRect);
        Screen('Flip', window);
        pause(1);
    end %for j
    
    for irep = 1:3
    br_check(irep) = bg(irep)/rg(irep);
    end
% end %i
Priority(0)
%ListenChar(0);
sca
fprintf('\n\n')

rg_avg = median(rg(1,2:3));
bg_avg = median(bg(1,2:3));
rb_avg = median(br(1,2:3));

Prev_bg = [Prev_bg ; bg];
Prev_rg = [Prev_rg ; rg]; 
Prev_br = [Prev_br ; br]; 
Prev_brcheck = [Prev_brcheck ; br_check]; 

% Save to mat file
aa = cd('/Users/clemente/Dropbox/Luminotecnia/2017/Chicago Lab files/2 Experiments/Color AfterImage_Exp_Room_150/2nd/1 Programs/A Outputs');
saveCmd = ['save ' saveFile ' hfpDate rg bg br br_check rg_avg bg_avg rb_avg Prev_rg Prev_bg Prev_br Prev_brcheck'];
eval(saveCmd)

end