function XYZ = LMS_to_XYZ(LMS)
% function XYZ = Color_Convert_LMS_to_XYZ(LMS)
%
% Converts fron Cone Activation (LMS) to CIE 1931 Tristimulus Value (XYZ)
%
% Takes: LMS (N, 3) - LMS coordinates
% Returns: XYZ (N, 3) - XYZ coordinates
% Dependencies: Variable_Report.m
%
% Created 2015-07-09 by KCM
%
% Updated 2015-07-09 by KCM
%
%Updated 2015-08-18 by SLE to be consistent with UC with s scaled to 1

%% Arguments
if ~exist('LMS', 'var') || isempty(LMS)
    fprintf(char(strcat({'\nColor_Convert_LMS_to_XYZ: '}, {'''LMS'' must be provided!\n\n'})))
    XYZ = []; return
end
if ~ismatrix(LMS) || size(LMS, 2) ~= 3
    fprintf(char(strcat({'\nColor_Convert_LMS_to_XYZ: '}, {'''LMS'' must have size (N, 3)!\n\n'})))
    XYZ = []; return
end
if sum(sum(~isfinite(LMS))) || sum(sum(~isreal(LMS)))
    fprintf(char(strcat({'\nColor_Convert_LMS_to_XYZ: '}, ...
        {'''LMS'' must be finite and real!\n\n'})))
    XYZ = []; return
end

%% Convert
XYZ = [2.9448 .* LMS(:, 1) - 3.5010 .* LMS(:, 2) + 0.2068 .* LMS(:, 3), ... % X
    1 .* LMS(:, 1) + 1 .* LMS(:, 2) + 0 .* LMS(:, 3), ... % Y
    0 .* LMS(:, 1) + 0 .* LMS(:, 2) + 0.9765 .* LMS(:, 3)]; clear LMS % Z
% 
% %% Variable Report (Housecleaning: for spotting uncleared variables.  Omit if desired)
% Variable_Report(whos, 'XYZ')

end
